#!/bin/bash

device=0

rm tmp -r -f

while true
do
	mkdir tmp
	
	if [ $device != 0 ]
	then
		avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m$device"p" -U signature:r:tmp/signature$device:i
		
		if [ ! -f tmp/signature$device ]
		then
			device=0
		fi
	fi
	
	if [ $device == 0 ]
	then
		avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m48p -U signature:r:tmp/signature48:i
		avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m88p -U signature:r:tmp/signature88:i
		avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m168p -U signature:r:tmp/signature168:i
		avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m328p -U signature:r:tmp/signature328:i
		avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m164p -U signature:r:tmp/signature164:i
		avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m324p -U signature:r:tmp/signature324:i
		avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m644p -U signature:r:tmp/signature644:i
		avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m1284p -U signature:r:tmp/signature1284:i
		
		if [ -f tmp/signature48 ]
		then
			device=48
		elif [ -f tmp/signature88 ]
		then
			device=88
		elif [ -f tmp/signature168 ]
		then
			device=168
		elif [ -f tmp/signature328 ]
		then
			device=328
		elif [ -f tmp/signature164 ]
		then
			device=164
		elif [ -f tmp/signature324 ]
		then
			device=324
		elif [ -f tmp/signature644 ]
		then
			device=644
		elif [ -f tmp/signature1284 ]
		then
			device=1284
		else
			device=0
		fi
	fi
	
	if [ $device != 0 ]
	then
		for file in *.cpp
		do
			if [ -f "$file" ]
			then
				cp "$file" tmp/tmp.cpp
				sed -i tmp/tmp.cpp -e "1i#define _ATMEGA"$device"P"
				
				clear
				
				if [ $device == 48 ] || [ $device == 88 ] || [ $device == 168 ] || [ $device == 328 ]
				then
					echo "Compiling and uploading "$file" to MODULABLE 20 with ATmega"$device"P :"
				else
					echo "Compiling and uploading "$file" to MODULABLE 32 with ATmega"$device"P :"
				fi
				
				avr-gcc tmp/tmp.cpp -mmcu=atmega$device"p" -I ../module -Wall -Wextra -Os -ffunction-sections -fdata-sections -Wl,--gc-sections -std=c++11 -o tmp/tmp.elf
				
				if [ -f tmp/tmp.elf ]
				then
					avrdude -q -P /dev/ttyACM0 -c usbasp -B 8 -p m$device"p" -e -U lfuse:w:0xff:m -U hfuse:w:0xdf:m -U efuse:w:0xfc:m
					avr-objcopy tmp/tmp.elf -O ihex tmp/tmp.hex
					avrdude -P /dev/ttyACM0 -c usbasp -p m$device"p" -U flash:w:tmp/tmp.hex:i
					avr-size tmp/tmp.elf -dC --mcu atmega$device"p"
				fi
			fi
		done
	fi
	
	rm tmp -r -f
	
	read
	clear
done

exit 0
